<?php

/* Magentix - http://www.magentix.fr - contact@magentix.fr */

class Magentix_FreeGift_Model_Observer {

		private $_gift,$_amount,$_coupon;
		
		public function __construct() {
		
			if(Mage::getStoreConfig('freegift/settings/enabled')) {
				$s = Mage::helper('freegift')->getSettings();
				
				$this->_amount = $s['amount'];
				$this->_gift = $s['gift'];
				$this->_coupon = $s['coupon'];
			}
			
		}
		
		public function add($observer) {
			$_id = $observer->getEvent()->getProduct()->getId();
			if($_id == $this->_gift) {
				$this->remove_item();
			} else {
				$this->add_gift();
			}
		}
		
		public function add_gift() {
			if($this->_gift) {
				$this->getQuote()->collectTotals();
				
				$this->remove_item();
				
				if($this->getCartTotal() > $this->_amount && $this->getCoupon()) {
					$this->_getCart()->addProductsByIds(array($this->_gift))->save();
				}
			}
		}
		
		public function remove_addtocart($observer) {
			if($this->_gift && Mage::registry('current_product') && Mage::registry('current_product')->getId() == $this->_gift) {
				if (!$addtocart = $observer->getLayout()->getXpath("//block[@name='product.info.addtocart']")) return $this;
				$addtocart[0]->addAttribute('ignore', true);
			}
			return $this;
		}
		
		public function remove_item() {
			foreach ($this->getQuote()->getAllItems() as $item) {
				if($item->getProductId() == $this->_gift) { $this->_getCart()->removeItem($item->getId())->save(); }
			}
		}
		
		public function getCoupon() {
			if(mb_eregi('^'.$this->_coupon.'$',$this->getQuote()->getCouponCode())) return true;

			return false;
		}
		
		public function getCartTotal() {
			$cart_amount = Mage::Helper('checkout/cart')->getCart()->getQuote()->getTotals();
			return $cart_amount['subtotal']->getValue();
		}

		public function getQuote() {
			return Mage::getSingleton('checkout/session')->getQuote();
		}
		
		public function _getCart() {
			return Mage::getSingleton('checkout/cart');
		}
}