<?php

/**
 * Footerlinks content block
 *
 * @category   BusinessKing
 * @package    BusinessKing_Footerlinks
 */
class BusinessKing_Footerlinks_Block_Page_Template_Links extends Mage_Page_Block_Template_Links
{
	public function getTopSearches()
	{
		$collection = Mage::getModel('footerlinks/footer')
            		->getTopSearches();

        return $collection;
	}
	
	public function getParentFooterLinks()
	{
		return Mage::getSingleton('footerlinks/footer')->getParentFooterLinks();
	}
	
	public function getFooterLinks($parentId, $isActive = '')
	{
		return Mage::getSingleton('footerlinks/footer')->getFooterLinks($parentId, $isActive);
	}
	
	public function getCategories()
	{
		$storeId = Mage_Catalog_Model_Abstract::DEFAULT_STORE_ID;
        $collection = $this->getData('category_collection');
        if (is_null($collection)) {
            $collection = Mage::getModel('catalog/category')->getCollection();

            /* @var $collection Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Collection */
            $collection->addAttributeToSelect('name')
            	->addAttributeToSelect('image')
            	->addAttributeToSelect('all_children')
                ->addAttributeToSelect('is_active')
                ->setProductStoreId($storeId)
                ->setLoadProductCount($this->_withProductCount)
                ->setStoreId($storeId);

            //$this->setData('category_collection', $collection);
        }
        return $collection;
	}
	
	public function getSubcategories($categoryId)
	{
		$storeId = Mage_Catalog_Model_Abstract::DEFAULT_STORE_ID;
        $collection = $this->getData('category_collection');
        if (is_null($collection)) {
            $collection = Mage::getModel('catalog/category')->getCollection();

            /* @var $collection Mage_Catalog_Model_Resource_Eav_Mysql4_Category_Collection */
            $collection->addAttributeToSelect('name')
            	->addAttributeToSelect('all_children')
                ->addAttributeToSelect('is_active')
                ->addFieldToFilter('parent_id',$categoryId)
                ->setProductStoreId($storeId)
                ->setLoadProductCount($this->_withProductCount)
                ->setStoreId($storeId);
        }
        return $collection;
	}
}
