<?php

class Stream_Giftproduct_Model_Giftproduct extends Mage_Core_Model_Abstract {

    public function _construct() {
        parent::_construct();
        $this->_init('giftproduct/giftproduct');
    }

    public function createCartRule() {
        $shoppingCartPriceRule = Mage::getModel('salesrule/rule');
        $shoppingCartPriceRule
                ->setName("Gift Product Free Shipping")
                ->setDescription('Gift product shipping cost will not be added to order total')
                ->setIsActive(1)
                ->setWebsiteIds(array(1))
                ->setCustomerGroupIds(array(0, 1, 2, 3))
                ->setFromDate('')
                ->setToDate('')
                ->setSortOrder('')
                ->setSimpleAction('by_fixed')
                ->setDiscountAmount(0)
                ->setSimpleFreeShipping(1)
                ->setStopRulesProcessing(0);
        $priceCondition = Mage::getModel('salesrule/rule_condition_product')
                ->setType('salesrule/rule_condition_product')
                ->setAttribute('quote_item_row_total')
                ->setOperator('==')
                ->setValue(0);
        try {
            $shoppingCartPriceRule->getActions()->addCondition($priceCondition);
            $shoppingCartPriceRule->save();
        } catch (Exception $e) {
            Mage::getSingleton('core/session')->addError(Mage::helper('catalog')->__($e->getMessage()));
            return;
        }
    }

}
